<%@ Page Title="PolyTrauma Tracking" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PolyTraumaEntry.aspx.cs"
    Inherits="PolyTraumaEntry" MaintainScrollPositionOnPostback="true" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<%@ Register Assembly="System.Web.DynamicData, Version=3.5.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35" Namespace="System.Web.DynamicData"
    TagPrefix="cc2" %>
<%@ Register Src="~/controls/Date.ascx" TagName="Date" TagPrefix="UserControlDate" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register Src="controls/ErrorList.ascx" TagName="ErrorList" TagPrefix="uc1" %>
<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
        }
        .style3
        {
            width: 4px;
        }
        .style4
        {
            width: 400px;
        }
        .style6
        {
        }
        .style8
        {
            width: 135px;
        }
        .style16
        {
        }
        .style17
        {
            width: 327px;
        }
        .style18
        {
            width: 270px;
        }
        .style19
        {
            width: 214px;
        }
        .requiredField
        {
            font-weight: bold;
            color: #FF0000;
        }
        .redText {
            color: red;
        }
    </style>
    <script type="text/javascript" language="javascript">
        function DeleteConfirmation() {
            if (confirm("Are you sure you want to delete this case?")) {
                return true;
            } else {
                return false;
            }
        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">

    <script src="scripts/date.js" type="text/javascript"></script>

    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>

    <script type="text/javascript">
        $(window).load(function() {
        });
        $(document).ready(function() {

            $('input[type=text].staylength').blur(function() {
                calculateLengthOfStay();
                
                calculateDaysFromOnset();                
            });                
        });

        function calculateLengthOfStay() {
            //alert('calculateLengthOfStay');
            if ($('input[id*= RehabDischargeDate]').val().trim().length == 0
                || $('input[id*= RehabAdmitDate]').val().trim().length == 0)

                return;

            if (Date.parse($('input[id*= RehabAdmitDate]').val(), "mm/dd/yyyy") == null 
                || Date.parse($('input[id*= RehabDischargeDate]').val(), "mm/dd/yyyy") == null)
                
                return;    

            var dateDiff = daydiff(
                Date.parse($('input[id*= RehabAdmitDate]').val(), "mm/dd/yyyy")
                , Date.parse($('input[id*= RehabDischargeDate]').val(), "mm/dd/yyyy")
                       
            )

            if ($('#<%= TextBoxDaysOffUnit.ClientID %>').val().trim().length > 0)
            {
                dateDiff = dateDiff - parseInt($('#<%= TextBoxDaysOffUnit.ClientID %>').val().trim(), 10); 
            }

            //set days to schedule appointment
            if (isNaN(dateDiff) || dateDiff < 0) {
                $('#<%=LabelLOSValue.ClientID %>').text('');
            }
            else {
                $('#<%=LabelLOSValue.ClientID %>').text(dateDiff);
            }
        }

        function calculateDaysFromOnset() {
            //alert('calculateDaysFromOnset');
            // try to calculate days from onset
            if ($('input[id*= TextBoxInjuryDate]').val().trim().length == 0
                || $('input[id*= RehabAdmitDate]').val().trim().length == 0)

                return;
            
            if (Date.parse($('input[id*= RehabAdmitDate]').val(), "mm/dd/yyyy") == null 
                || Date.parse($('input[id*= TextBoxInjuryDate]').val(), "mm/dd/yyyy") == null)
                
                return; 
            
            // if todaysDate < admitDate => Admission date in future ... do not calculate.
            
            var admitDate = Date.parse($('input[id*= RehabAdmitDate]').val(), "mm/dd/yyyy");
            var todaysDate = new Date();
                        
            var daysFromOnsetDiff = daydiff(Date.parse($('input[id*= TextBoxInjuryDate]').val(), "mm/dd/yyyy"), Date.parse($('input[id*= RehabAdmitDate]').val(), "mm/dd/yyyy"));
           
            //set days from onset
            if (todaysDate > admitDate) {
                if (isNaN(daysFromOnsetDiff) || daysFromOnsetDiff < 0) {
                    $('#<%=LabelDaysFromOnsetValue.ClientID %>').text('');
                }
                else {
                    $('#<%=LabelDaysFromOnsetValue.ClientID %>').text(daysFromOnsetDiff);
                }
            } else {
                $('#<%=LabelDaysFromOnsetValue.ClientID %>').text('');
            }
        }

        function daydiff(first, second) {
            return Math.round((second - first) / (1000 * 60 * 60 * 24))
        }


        function checkDateofDeathAgeValidate(sender, args)
        {
            args.IsValid = true;

            var dob = $('#<%= TextBoxDateOfBirth.ClientID %>').val();

            var dod = $('#<%= TextBoxDateOfDeath.ClientID %>').val();


            var byr = dob.split('/')[2];
            if (byr.length == 2) byr = (byr > 29) ? '19' + byr : '20' + byr;
            dob = dob.split('/'); dob[2] = byr; dob = dob.join('/');

            var dyr = dod.split('/')[2];
            if (dyr.length == 2) dyr = (dyr > 29) ? '19' + dyr : '20' + dyr;
            dod = dod.split('/'); dod[2] = dyr; dod = dod.join('/');

            var dBirth = new Date(dob);
            
            var dDeath = new Date(dod);

            //alert(dBirth);
            //alert(dDeath);
            //var dob = new Date($('#<%= TextBoxDateOfBirth.ClientID %>').val());

            //var dod = new Date($('#<%= TextBoxDateOfDeath.ClientID %>').val());

            dDeath.setFullYear(dDeath.getFullYear() - 18);


            if ((dDeath - dBirth) < 0)
            {
                args.IsValid = false;
            }
            else
            {
                args.IsValid = true;
            }

        }

        
    </script>

    <asp:ValidationSummary ID="ValidationSummaryPolyTraumaEntry" runat="server" TabIndex="1" ValidationGroup="OnSave" HeaderText="The page has the following data errors:"
        DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="True" />
    <asp:ValidationSummary ID="ValidationSummaryPolyTraumaEntryPTRP" runat="server" TabIndex="2" ValidationGroup="OnPTRPSave"
        HeaderText="The page has the following data errors:" DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="True" />
    <asp:ValidationSummary ID="ValidationSummaryOnSearch" runat="server" TabIndex="3" ValidationGroup="OnSearch" HeaderText="The page has the following data errors:"
        DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="True" />
    <asp:Panel ID="PanelObjectContent" runat="server">
        <br />
        <uc1:ErrorList ID="ErrorList1" runat="server" />
        <asp:Panel ID="PanelPatientExistsNotice" runat="server" BorderColor="Red" BorderStyle="Solid" BorderWidth="1" Visible="false"
            Width="100%">
            <table border="0">
                <tr>
                    <td>
                        <asp:Label ID="LabelPatientExistsWarning" runat="server" ForeColor="Red" AssociatedControlID="LabelPatientExistsWarningText"
                            SkinID="DataLabel">Warning Patient Exists</asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelPatientExistsWarningText" runat="server" SkinID="DataLabel">
                             A record in the polytrauma registry exists for the patient that you selected.  If this is a new admission then click &quot;New Admission&quot; continue.
                        </asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Button ID="ButtonPatientExistsContinue" runat="server" OnClick="ButtonPatientExistsContinue_Click" Text=" New Admission " />
                        <asp:HiddenField ID="HiddenFieldPatientExistsSelectedID" runat="server" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <br />
        <asp:Panel ID="PanelSelectPatient" runat="server" GroupingText="Select Patient from VA Patient List&nbsp;&nbsp;" Width="100%"
            SkinID="DataLabel">
            <br />
            <div class="excludeSaveWarnings">
                <asp:Label ID="LabelforTextBoxSnumSearch" runat="server" AssociatedControlID="TextBoxSnumSearch">SSN:</asp:Label>
                <br />
                <asp:TextBox ID="TextBoxSnumSearch" runat="server" TabIndex="4" MaxLength="12">
                </asp:TextBox>
                <asp:RegularExpressionValidator ControlToValidate="TextBoxSnumSearch" TabIndex="5" ValidationGroup="OnSearch" Display="Static"
                    runat="server" ID="SSNValidator" EnableClientScript="true" ErrorMessage="SSN needs to be in the following format (dashes optional): XXX-XX-XXXX.  Include a 'P' or 'p' at the end for pseudo SSNs."
                    SetFocusOnError="true" ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$">
                </asp:RegularExpressionValidator>
                <br />
                <br />
                <asp:Label ID="LabelforTextBoxPatientNameSearch" runat="server" AssociatedControlID="TextBoxPatientNameSearch">Patient Last Name:
                </asp:Label>
                <br />
                <asp:TextBox ID="TextBoxPatientNameSearch" runat="server" TabIndex="6">
                </asp:TextBox>
                <br />
                <br />
                <asp:Button ID="ButtonSearchPatient" runat="server" TabIndex="7" ValidationGroup="OnSearch" Text="  Search  " OnClick="ButtonSearchPatient_Click" />
                <br />
                <br />
            </div>
            <asp:GridView ID="GridViewPatients" runat="server" Visible="False" TabIndex="8" DataKeyNames="PATIENT_ID" AutoGenerateColumns="False"
                Width="100%" DataSourceID="ObjectDataSourcePatientsCriteriaSearch" AllowPaging="True" AllowSorting="True" OnSelectedIndexChanged="GridViewPatients_SelectedIndexChanged">
                <Columns>
                    <asp:CommandField ShowCancelButton="False" ShowSelectButton="True" />
                    <asp:BoundField DataField="Snum" HeaderText="SSN" SortExpression="Snum">
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:BoundField DataField="FullName" HeaderText="Full Name" SortExpression="LAST_NAME">
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="Service Branch" SortExpression="STD_SERVICEBRANCH.NAME">
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:Label ID="LabelServiceBranch" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_SERVICEBRANCH.NAME")))%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <br />
            <asp:Label ID="Label1" runat="server" SkinID="DataLabel"><i><u>Note:</u> This lookup searches in the VA patient list, but it doesn't search already existing Polytrauma records. If the patient you are trying to enter already has a Polytrauma record, you will get notified on the next screen.</i></asp:Label>
            <br />
            <br />
        </asp:Panel>
        <asp:Label ID="LabelOrMessage" runat="server" SkinID="DataLabel"><font size="+1"><br /><b>OR</b><br /><br /></font></asp:Label>
        <asp:Panel ID="PanelManualPatientEntry" runat="server" GroupingText="Manually Enter New Record&nbsp;&nbsp;" Width="100%"
            SkinID="DataLabel">
            <br />
            <asp:Label ID="Label3" SkinID="DataLabel" runat="server" Text="If you can't find the patient above, you can enter the record manually here."></asp:Label>
            <br />
            <br />
            <asp:Button ID="ButtonSkipPatient" runat="server" TabIndex="9" Text=" Continue Without Selecting Patient " ToolTip="If the patient is not found, continue to enter all patient data."
                OnClick="ButtonSkipPatient_Click" />
            <br />
            <br />
            <asp:ObjectDataSource ID="ObjectDataSourcePatientsCriteriaSearch" runat="server" SelectMethod="SelectCriteriaSearch" SelectCountMethod="SelectCriteriaSearchCount"
                StartRowIndexParameterName="startRow" MaximumRowsParameterName="maxRows" SortParameterName="sort" EnablePaging="True"
                TypeName="VeteransAffairs.Registries.BusinessManager.PatientManager" DataObjectTypeName="VeteransAffairs.Registries.Business.TBI.PATIENT">
                <SelectParameters>
                    <asp:ControlParameter ControlID="TextBoxPatientNameSearch" Direction="Input" Name="lastName" Type="String" />
                    <asp:ControlParameter ControlID="TextBoxSnumSearch" Direction="Input" Name="snum" Type="String" />
                    <asp:Parameter DefaultValue="false" Type="Boolean" Name="searchReferrals" />
                    <asp:Parameter Name="fromDate" ConvertEmptyStringToNull="true" Type="String" />
                    <asp:Parameter Name="toDate" ConvertEmptyStringToNull="true" Type="String" />
                    <asp:Parameter DefaultValue="0" Type="String" Name="visn" />
                    <asp:Parameter DefaultValue="0" Type="String" Name="station" />
                    <asp:Parameter DefaultValue="0" Type="String" Name="status" />
                    <asp:Parameter Name="sort" Type="String" />
                    <asp:Parameter Name="startRow" Type="Int32" />
                    <asp:Parameter Name="maxRows" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </asp:Panel>
        <asp:Panel ID="PanelPatientReadOnly" runat="server" GroupingText="Patient Information&nbsp;&nbsp;" Width="100%">
            <table class="style1">
                <tr>
                    <td class="style2" colspan="4">
                        <asp:Label ID="LabelforLabelSSNReadOnly" runat="server" AssociatedControlID="LabelSSNReadOnly" SkinID="DataLabel">SSN:
                        </asp:Label>
                        &nbsp;<asp:Label ID="LabelSSNReadOnly" runat="server" SkinID="DataLabel" />&nbsp;
                    </td>
                </tr>
                <tr>
                    <td class="style2">
                        <asp:Label ID="LabelforLabelFullName" runat="server" AssociatedControlID="LabelFullName">Patient Name:
                        </asp:Label>
                        <asp:Label ID="LabelFullName" runat="server" SkinID="DataLabel"></asp:Label>
                    </td>
                    <td>
                        &nbsp;
                    </td>
                    <td class="style3">
                        &nbsp;
                    </td>
                    <td class="style4">
                        <asp:Label ID="LabelforLabelHomeVAMCReadOnly" runat="server" AssociatedControlID="LabelHomeVAMCReadOnly" SkinID="DataLabel">Home VAMC:
                        </asp:Label>
                        <asp:Label ID="LabelHomeVAMCReadOnly" runat="server" SkinID="DataLabel"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" align="center">
                        <br />
                        <asp:LinkButton ID="LinkButtonEditPatientInformation" runat="server" CssClass="excludeSaveWarnings" TabIndex="10" OnClick="LinkButtonEditPatientInformation_Click">Edit Patient Information
                        </asp:LinkButton>
                        <br />
                        <br />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelEntryType" runat="server" GroupingText="Entry Type&nbsp;&nbsp;" Width="100%">
            <asp:Label ID="LabelForPolytraumaEntryType" runat="server" AssociatedControlID="rblPolytraumaEntryType">
                Type of Entry <span class="requiredField">*</span>:
            </asp:Label><br />
            <asp:RadioButtonList ID="rblPolytraumaEntryType" runat="server" DataSourceID="ObjectDataSourcePolytraumaEntryType" DataTextField="NAME"
                TabIndex="11" DataValueField="ID" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="rblPolytraumaEntryType_SelectedIndexChanged">
            </asp:RadioButtonList>
            <asp:RequiredFieldValidator ID="RequiredFieldValidatorPolytraumaEntryType" ControlToValidate="rblPolytraumaEntryType" TabIndex="12"
                ValidationGroup="OnSave" Display="Dynamic" runat="server" EnableClientScript="true" ErrorMessage="Type of Entry is required."
                SetFocusOnError="true">
            </asp:RequiredFieldValidator>
            <br />
            <asp:Label ID="LabelForIsFollowUp" runat="server" AssociatedControlID="rblIsFollowUp">
                Type of Submission <span class="requiredField">*</span>:
            </asp:Label><br />
            <asp:RadioButtonList ID="rblIsFollowUp" runat="server" TabIndex="13" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="rblIsFollowUp_SelectedIndexChanged">
                <asp:ListItem Text="Admission" Value="0" />
                <asp:ListItem Text="Follow-Up" Value="1" />
            </asp:RadioButtonList>
            <asp:RequiredFieldValidator ID="RequiredFieldValidatorIsFollowUp" ControlToValidate="rblIsFollowUp" TabIndex="14" ValidationGroup="OnSave"
                Display="Dynamic" runat="server" EnableClientScript="true" ErrorMessage="Submission Type is required." SetFocusOnError="true">
            </asp:RequiredFieldValidator>
        </asp:Panel>
        <br />
        <asp:Panel ID="PanelPatient" runat="server" GroupingText="Patient Information&nbsp;&nbsp;" Width="100%">
            <table border="0">
                <tr>
                    <td>
                        <asp:Label ID="LabelforTextBoxSnum" runat="server" AssociatedControlID="TextBoxSnum">SSN <span class="requiredField">*</span>:
                        </asp:Label>
                        <asp:TextBox ID="TextBoxSnum" runat="server" MaxLength="12" TabIndex="15">
                        </asp:TextBox>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidatorTextBoxSnum" ControlToValidate="TextBoxSnum" TabIndex="16" ValidationGroup="OnSave"
                            Display="Static" runat="server" EnableClientScript="true" ErrorMessage="SSN needs to be in the following format (dashes optional): XXX-XX-XXXX.  Include a 'P' or 'p' at the end for pseudo SSNs."
                            SetFocusOnError="true" ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$">
                        </asp:RegularExpressionValidator>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxSnum" ControlToValidate="TextBoxSnum" TabIndex="17" ValidationGroup="OnSave"
                            Display="Static" runat="server" EnableClientScript="true" ErrorMessage="SSN is required." SetFocusOnError="true">
                        </asp:RequiredFieldValidator>
                        <asp:HiddenField ID="HiddenFieldPatientID" runat="server" />
                    </td>
                    <td>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforTextBoxFirstName" runat="server" AssociatedControlID="TextBoxFirstName">First Name <span class="requiredField">*</span>:
                        </asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxFirstName" runat="server" TabIndex="18" MaxLength="50" Width="200px" />
                        <br />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxFirstName" ControlToValidate="TextBoxFirstName" TabIndex="19"
                            ValidationGroup="OnSave" Display="Static" runat="server" EnableClientScript="true" ErrorMessage="First Name is required."
                            SetFocusOnError="true">
                        </asp:RequiredFieldValidator>
                    </td>
                    <td>
                        <asp:Label ID="LabelforTextBoxMiddleName" runat="server" AssociatedControlID="TextBoxMiddleName">Middle Name:
                        </asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxMiddleName" runat="server" TabIndex="20" MaxLength="50" Width="120px" />
                    </td>
                    <td>
                        <asp:Label ID="LabelforTextBoxLastName" runat="server" AssociatedControlID="TextBoxLastName">Last Name <span class="requiredField">*</span>:
                        </asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxLastName" runat="server" TabIndex="21" MaxLength="50" Width="250px" />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxLastName" ControlToValidate="TextBoxLastName" TabIndex="22"
                            ValidationGroup="OnSave" Display="Static" runat="server" EnableClientScript="true" ErrorMessage="Last Name is required."
                            SetFocusOnError="true">
                        </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListGender" runat="server" AssociatedControlID="DropDownListGender">Gender:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListGender" runat="server" TabIndex="23" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceGender"
                            DataTextField="NAME" DataValueField="ID" Width="231px">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:Label ID="LabelforTextBoxDateOfBirth" runat="server" AssociatedControlID="TextBoxDateOfBirth">Date of Birth (mm/dd/yyyy):
                        </asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxDateOfBirth" runat="server" Text="" TabIndex="24" />
                        <asp:RangeValidator ID="RangeValidatorTextBoxDateOfBirth" runat="server" ValidationGroup="OnSave" TabIndex="25" EnableClientScript="true"
                            SetFocusOnError="true" ErrorMessage="Date of Birth needs to be a valid past date in format mm/dd/yyyy and not later than Date of Death."
                            Type="Date" Display="Static" ControlToValidate="TextBoxDateOfBirth">
                        </asp:RangeValidator>
                        <asp:CompareValidator ID="CompareValidatorTextBoxDateOfBirth" runat="server" ValidationGroup="OnSave" Operator="DataTypeCheck"
                            ControlToValidate="TextBoxDateOfBirth" Type="Date" EnableClientScript="true" SetFocusOnError="true" Display="Dynamic"
                            ErrorMessage="Date of Birth needs to be a valid date.">
                        </asp:CompareValidator>
                        <asp:RegularExpressionValidator ID="RegexValidatorBirthDate" runat="server" ValidationGroup="OnSave" EnableClientScript="true"
                            SetFocusOnError="true" ErrorMessage="Date of Birth needs to be a valid date and in format (mm/dd/yyyy)." Type="Date"
                            ControlToValidate="TextBoxDateOfBirth" ValidationExpression="^(0?[1-9]|1[012])(/)(0?[1-9]|[12][0-9]|3[01])(/)(19|20)[0-9]{2}$">                        
                        </asp:RegularExpressionValidator>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListMaritalStatus" runat="server" AssociatedControlID="DropDownListMaritalStatus">Marital Status:</asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListMaritalStatus" runat="server" TabIndex="26" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceMaritalStatus"
                            DataTextField="NAME" DataValueField="ID" Width="231px">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:Label ID="LabelforTextBoxDateOfDeath" runat="server" AssociatedControlID="TextBoxDateOfDeath">Date of Death (mm/dd/yyyy):
                        </asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxDateOfDeath" runat="server" Text="" TabIndex="27" />
                        <asp:CompareValidator ID="CompareValidatorTextBoxDateOfDeath" runat="server" ValidationGroup="OnSave" EnableClientScript="true"
                            SetFocusOnError="true" ErrorMessage="Date of Death needs to be a valid date in and later than Date of Birth." Type="Date"
                            Display="Static" ControlToValidate="TextBoxDateOfDeath" ControlToCompare="TextBoxDateOfBirth" Operator="GreaterThanEqual">     
                        </asp:CompareValidator>
                        <asp:RegularExpressionValidator ID="RegexValidatorDeathDate" runat="server" ValidationGroup="OnSave" EnableClientScript="true"
                            SetFocusOnError="true" ErrorMessage="Date of Death needs to be a valid date and in format (mm/dd/yyyy)." Type="Date"
                            ControlToValidate="TextBoxDateOfDeath" ValidationExpression="^(0?[1-9]|1[012])[/](0?[1-9]|[12][0-9]|3[01])[/](19|20)[0-9]{2}$">                        
                        </asp:RegularExpressionValidator>
                        <asp:CompareValidator ID="CompareValidatorDeathPastDaste" runat="server" ValidationGroup="OnSave" EnableClientScript="true"
                            SetFocusOnError="true" ErrorMessage="Date of Death needs to be a past date." Type="Date" Display="Dynamic" ControlToValidate="TextBoxDateOfDeath"
                            Operator="LessThanEqual">     
                        </asp:CompareValidator>
                        <asp:CustomValidator ID="CustomValidatorTextBoxDateOfDeath" runat="server" Display="Static" ErrorMessage="Person must be at least 18 years of age at the time of death."
                            ClientValidationFunction="checkDateofDeathAgeValidate" ValidationGroup="OnSave" EnableClientScript="true" SetFocusOnError="true"
                            ControlToValidate="TextBoxDateOfDeath" />
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListRace" runat="server" AssociatedControlID="DropDownListRace">Race:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListRace" runat="server" TabIndex="28" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceRace"
                            DataTextField="NAME" DataValueField="ID" Width="227px">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:Label ID="LabelforDropDownListEthnicity" runat="server" AssociatedControlID="DropDownListEthnicity">Ethnicity:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListEthnicity" runat="server" TabIndex="29" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceEthnicity"
                            DataTextField="NAME" DataValueField="ID">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br />
                        <table border="0">
                            <tr>
                                <td>
                                    <asp:Label ID="LabelforTextBoxAddressLine1" runat="server" AssociatedControlID="TextBoxAddressLine1">Address:
                                    </asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxAddressLine1" runat="server" TabIndex="30" MaxLength="100" Width="350px" />
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelforTextBoxAddressLine2" runat="server" AssociatedControlID="TextBoxAddressLine2">Address Line 2:</asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxAddressLine2" runat="server" TabIndex="31" MaxLength="100" Width="350px" />
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelforTextBoxAddressLine3" runat="server" AssociatedControlID="TextBoxAddressLine3">Address Line 3:</asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxAddressLine3" runat="server" TabIndex="32" MaxLength="100" Width="350px" />
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelforTextBoxCounty" runat="server" AssociatedControlID="TextBoxCounty">County:</asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxCounty" runat="server" TabIndex="33" MaxLength="50" Width="200px" />
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <br />
                        <table border="0">
                            <tr>
                                <td align="left">
                                    <asp:Label ID="LabelforTextBoxCity" runat="server" AssociatedControlID="TextBoxCity">City:
                                    </asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxCity" runat="server" TabIndex="34" MaxLength="60" Width="200px" />
                                </td>
                            </tr>
                            <tr>
                                <td align="left">
                                    <asp:Label ID="LabelforTextBoxState" runat="server" AssociatedControlID="TextBoxState">State:</asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxState" runat="server" TabIndex="35" MaxLength="50" Width="200px" />
                                </td>
                            </tr>
                            <tr>
                                <td align="left">
                                    <asp:Label ID="LabelforTextBoxPostalCode" runat="server" AssociatedControlID="TextBoxPostalCode">Postal Code:</asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxPostalCode" runat="server" TabIndex="36" MaxLength="20" Width="100px" />
                                </td>
                            </tr>
                            <tr>
                                <td align="left">
                                    <asp:Label ID="LabelforTextBoxCountry" runat="server" AssociatedControlID="TextBoxCountry">Country:</asp:Label>
                                    <br />
                                    <asp:TextBox ID="TextBoxCountry" runat="server" TabIndex="37" MaxLength="50" Width="200px" />
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforTextBoxHomePhone" runat="server" AssociatedControlID="TextBoxHomePhone">Phone:</asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxHomePhone" runat="server" TabIndex="38" MaxLength="30" Width="110px" />
                    </td>
                    <td>
                        <asp:Label ID="LabelforTextBoxEmailAddress" runat="server" AssociatedControlID="TextBoxEmailAddress">Email Address:
                        </asp:Label>
                        <br />
                        <asp:TextBox ID="TextBoxEmailAddress" runat="server" TabIndex="39" MaxLength="128" Width="250px" />
                        <asp:RegularExpressionValidator ID="UserEMailValidator" runat="server" TabIndex="40" SetFocusOnError="true" ControlToValidate="TextBoxEmailAddress"
                            ErrorMessage="Patient Information - Email Address is invalid" ValidationExpression="^\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*$"
                            ValidationGroup="OnSave" Display="Static">
                        </asp:RegularExpressionValidator>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br />
                        <asp:Label ID="LabelforDropDownListHomeVAMC" runat="server" AssociatedControlID="DropDownListHomeVAMC">Home VAMC <span class="requiredField">*</span>:</asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListHomeVAMC" runat="server" AppendDataBoundItems="true" TabIndex="41" DataSourceID="ObjectDataSourceVAMC"
                            DataTextField="FullVISNName" DataValueField="ID">
                            <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorHomeVAMC" runat="server" ControlToValidate="DropDownListHomeVAMC" TabIndex="42"
                            EnableClientScript="true" ErrorMessage="Home VAMC is required." InitialValue="0" ValidationGroup="OnSave" SetFocusOnError="true"
                            Display="Dynamic">
                        </asp:RequiredFieldValidator>
                    </td>
                    <td>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListMilitaryServiceBranch" runat="server" AssociatedControlID="DropDownListMilitartServiceBranch">Military Service Branch:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListMilitartServiceBranch" runat="server" TabIndex="141" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceMilitaryServiceBranch"
                            DataTextField="NAME" DataValueField="ID">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:Label ID="LabelforDropDownListMilitaryServiceStatus" runat="server" AssociatedControlID="DropDownListMilitaryServiceStatus">Military Duty Status at Admission:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListMilitaryServiceStatus" runat="server" TabIndex="142" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceMilitaryServiceStatus"
                            DataTextField="NAME" DataValueField="ID">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelforDropDownListDischargeStatus" runat="server" AssociatedControlID="DropDownListDischargeStatus">Military Status at Discharge:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="DropDownListDischargeStatus" runat="server" TabIndex="143" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceDischargeStatus"
                            DataTextField="NAME" DataValueField="ID">
                            <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                    </td>
                    <td>
                    </td>
                </tr>
            </table>
            &nbsp;
            <br />
            <asp:Label ID="LabelforDropDownListPolyTraumaVAMC" runat="server" AssociatedControlID="DropDownListPolyTraumaVAMC">
                                Polytrauma VAMC <span class="requiredField">*</span>:
            </asp:Label>
            <br />
            <asp:DropDownList ID="DropDownListPolyTraumaVAMC" runat="server" TabIndex="144" AppendDataBoundItems="true" DataSourceID="ObjectDataSourcePolyTraumaVAMC"
                DataTextField="Name" DataValueField="institution_id">
                <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
            </asp:DropDownList>
            &nbsp;&nbsp;
            <br />
            <asp:RequiredFieldValidator ID="RequiredFieldValidatorPolyTraumaVAMC" TabIndex="145" runat="server" ControlToValidate="DropDownListPolyTraumaVAMC"
                ErrorMessage="Polytrauma VAMC is required" InitialValue="0" ValidationGroup="OnSave" SetFocusOnError="true" Display="Static">
            </asp:RequiredFieldValidator>
        </asp:Panel>
                 
        <asp:Panel ID="PanelTracking" runat="server" GroupingText="PRC Tracking&nbsp;&nbsp;" Width="100%">
            <asp:Button runat="server" ID="ShowPTRPPanelButton" OnClick="ShowPTRPPanelButtonClick" Text="Switch to PTRP Tracking" style="background-color:White;color:Gray;border: solid 1px LightGray;position:relative;left:100px;top:-20px;border-radius:5px;padding:3px;cursor:pointer;font-size:8pt;" />
            <br />
            &nbsp;&nbsp;<asp:Label ID="LabelforDropDownListTBIFacilitySource" runat="server" AssociatedControlID="DropDownListTBIFacilitySource">MTF / Referral Source:
            </asp:Label>
            <br />
            &nbsp;&nbsp;
            <asp:DropDownList ID="DropDownListTBIFacilitySource" runat="server" TabIndex="146" DataSourceID="ObjectDataSourceTBIFacilitySource"
                DataTextField="NAME" DataValueField="ID" AppendDataBoundItems="true">
                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
            </asp:DropDownList>
            <br />
            <br />
            <asp:Panel ID="PanelTraumaInformation" runat="server" GroupingText="Trauma Information&nbsp;&nbsp;" Width="99%">
                <br />
                <table width="99%">
                    <tr>
                        <td>
                            <asp:Label ID="LabelforTextBoxInjuryDate" runat="server" AssociatedControlID="TextBoxInjuryDate">
                                Injury Date (mm/dd/yyyy):
                            </asp:Label>
                            <br />
                            <asp:TextBox ID="TextBoxInjuryDate" runat="server" Text="" CssClass="staylength" TabIndex="147" />
                            <br />
                            <asp:RangeValidator ID="RangeValidatorTextBoxInjuryDate" runat="server" ValidationGroup="OnSave" TabIndex="148" EnableClientScript="true"
                                SetFocusOnError="true" ErrorMessage="PRC Tracking - Injury Date needs to be a valid date in format (mm/dd/yyyy) and not later than today."
                                Type="Date" Display="Static" ControlToValidate="TextBoxInjuryDate">
                            </asp:RangeValidator>
                        </td>
                    </tr>
                </table>
                <table width="99%">
                    <tr>
                        <td class="style19">
                            <asp:Label ID="LabelforDropDownListCombatLocation" runat="server" AssociatedControlID="DropDownListCombatLocation">
                                Injury Geographic Location:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListCombatLocation" runat="server" TabIndex="149" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceCombatLocation"
                                DataTextField="NAME" DataValueField="ID">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td class="style8">
                            <asp:Label ID="LabelforDropDownListBlastExplosion" runat="server" AssociatedControlID="DropDownListBlastExplosion">
                                Blast Injury: <!-- formerly Blast Explosion -->
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListBlastExplosion" runat="server" TabIndex="150">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                                <asp:ListItem Value="Y">Yes</asp:ListItem>
                                <asp:ListItem Value="N">No</asp:ListItem>
                                <asp:ListItem Value="U">Unknown</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td>
                            <asp:Label ID="LabelforDropDownListVechicleInjury" runat="server" AssociatedControlID="DropDownListVechicleInjury">
                                Vehicle Injury:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListVechicleInjury" runat="server" TabIndex="151">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                                <asp:ListItem Value="Y">Yes</asp:ListItem>
                                <asp:ListItem Value="N">No</asp:ListItem>
                                <asp:ListItem Value="U">Unknown</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td class="style19">
                            <asp:Label ID="LabelforDropDownListBulletInjury" runat="server" AssociatedControlID="DropDownListBulletInjury">
                            Bullet Injury:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListBulletInjury" runat="server" TabIndex="152">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                                <asp:ListItem Value="Y">Yes</asp:ListItem>
                                <asp:ListItem Value="N">No</asp:ListItem>
                                <asp:ListItem Value="U">Unknown</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td class="style8">
                            <asp:Label ID="LabelforDropDownListPhysicalAssault" runat="server" AssociatedControlID="DropDownListPhysicalAssault">
                                Physical Assault:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListPhysicalAssault" runat="server" TabIndex="153">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                                <asp:ListItem Value="Y">Yes</asp:ListItem>
                                <asp:ListItem Value="N">No</asp:ListItem>
                                <asp:ListItem Value="U">Unknown</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td class="style8">
                            <asp:Label ID="LabelforDropDownListOtherInjury" runat="server" AssociatedControlID="DropDownListOtherInjury">
                                Other Injury:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListOtherInjury" runat="server" TabIndex="154" onchange="SetTextBoxOtherInjuryDescriptionEnabledStatus();">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                                <asp:ListItem Value="Y">Yes</asp:ListItem>
                                <asp:ListItem Value="N">No</asp:ListItem>
                                <asp:ListItem Value="U">Unknown</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                </table>
                <table width="99%">
                    <tr>
                        <td>
                            <asp:Label ID="LabelforTextBoxOtherInjuryDescription" runat="server" AssociatedControlID="TextBoxOtherInjuryDescription">
                                Other Injury Description:
                            </asp:Label>
                            <br />
                            <asp:TextBox ID="TextBoxOtherInjuryDescription" runat="server" TabIndex="155" MaxLength="255" Rows="3" TextMode="MultiLine"
                                Width="99%" />
                            <asp:RegularExpressionValidator ID="TextBoxOtherInjuryDescriptionValidator" TabIndex="156" runat="server" ControlToValidate="TextBoxOtherInjuryDescription"
                                ErrorMessage="PRC Tracking - Other Injury Description needs to be less than 255 characters." ValidationGroup="OnSave" ValidationExpression="^[\s\S]{0,255}$"
                                SetFocusOnError="true" Display="Static">
                            </asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td class="style6" colspan="5">
                            <asp:Panel ID="PanelInjuryDetails" runat="server" GroupingText="Injury Details&nbsp;&nbsp;" BorderStyle="None">
                                <asp:CheckBoxList ID="CheckBoxListInjuryDetails" runat="server" TabIndex="157" DataSourceID="ObjectDataSourceInjuryDetailList"
                                    DataTextField="NAME" DataValueField="ID" RepeatColumns="2" RepeatDirection="Horizontal" RepeatLayout="Table">
                                </asp:CheckBoxList>
                            </asp:Panel>
                            <br />
                            <asp:Label ID="LabelForSeverityLevelIndexTBI" runat="server" AssociatedControlID="rblSeverityLevelIndexTBI">
                            Severity Level of Index TBI <span class="requiredField">*</span>:
                            </asp:Label>
                            <br />
                            <asp:RadioButtonList ID="rblSeverityLevelIndexTBI" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceSeverityLevelIndexTBI"
                                DataTextField="NAME" DataValueField="ID" ValidationGroup="OnSave" TabIndex="158">
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorSeverityLevelIndexTBI" ControlToValidate="rblSeverityLevelIndexTBI"
                                TabIndex="159" ValidationGroup="OnSave" Display="Static" runat="server" EnableClientScript="true" ErrorMessage="PRC Tracking - Severity Level of Index TBI is required."
                                SetFocusOnError="true">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                </table>
            </asp:Panel>
            <br />
            <asp:Panel ID="PanelTreatmentInformation" runat="server" GroupingText="Treatment&nbsp;&nbsp;" Width="99%">
                <br />
                <table class="style1">
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:CheckBox ID="CheckBoxEmergingConsciousness" runat="server" TabIndex="180" Text="&nbsp;Is Patient Emerging Consciousness" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="LabelforDropDownListEmergingEtiology" runat="server" AssociatedControlID="DropDownListEmergingEtiology">
                                Detailed Emerging Consciousness Etiology:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListEmergingEtiology" runat="server" TabIndex="181" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceEmergingEtiology"
                                DataTextField="DESCRIPTION_TEXT" DataValueField="ID">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                    </tr>
                </table>
                <asp:TextBox ID="HiddenFieldDateOfDeath" Style="display: none" runat="server" />
                <asp:TextBox ID="HiddenFieldDateOfBirth" Style="display: none" runat="server" />
                <table class="style1">
                    <tr>
                        <td class="style17" style="width: 50%">
                            <asp:Label ID="LabelforTextBoxAlteredConsciousnessDate" runat="server" AssociatedControlID="TextBoxDateAlteredConsciousness"
                                Text="Date of Injury Resulting in Disorder of Consciousness (mm/dd/yyyy):"></asp:Label>
                        </td>
                        <td class="style16" style="width: 50%">
                            <asp:Label ID="LabelforTextBoxPatientEmergedDate" runat="server" ToolTip="Emergence defined by: 1. Object use, 2. Reliable yes/no communication, 3. Consistent or reliable command following  defined by CRS-R"
                                Text="Date Patient Emerged (mm/dd/yyyy):" AssociatedControlID="PatientEmergedDate:TextBoxDate"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            <asp:TextBox ID="TextBoxDateAlteredConsciousness" runat="server" Text="" TabIndex="182" />
                            <br />
                            <asp:RangeValidator ID="RangeValidatorDateAlteredConsciousness" runat="server" ValidationGroup="OnSave" TabIndex="183" EnableClientScript="true"
                                SetFocusOnError="true" ErrorMessage="PRC Tracking - Date of Injury Resulting in Disorder of Consciousness needs to be a valid date in format (mm/dd/yyyy) and not later than today"
                                Type="Date" Display="Static" ControlToValidate="TextBoxDateAlteredConsciousness">
                            </asp:RangeValidator>
                            <asp:CompareValidator ID="CompareValidatorDateAlteredConsciousnessDOB" runat="server" ControlToValidate="TextBoxDateAlteredConsciousness"
                                ControlToCompare="TextBoxDateOfBirth" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="GreaterThanEqual"
                                ErrorMessage="PRC Tracking - Date of Injury Resulting in Disorder of Consciousness needs to be later than Date of Birth." Display="Dynamic"
                                Type="Date" />
                            <asp:CompareValidator ID="CompareValidatorDateAlteredConsciousnessDOD" runat="server" ControlToValidate="TextBoxDateAlteredConsciousness"
                                ControlToCompare="TextBoxDateOfDeath" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="LessThanEqual"
                                ErrorMessage="PRC Tracking - Date of Injury Resulting in Disorder of Consciousness needs to be less than or equal to Date of Death."
                                Display="Dynamic" Type="Date" />
                        </td>
                        <td class="style16" style="width: 50%">
                            <UserControlDate:Date ID="PatientEmergedDate" runat="server" ToDate="true" StartTabIndex="184" ErrorMessage="PRC Tracking - Date Patient Emerged needs to be a valid date in format (mm/dd/yyyy) and not later than today"
                                ValidationGroup="OnSave" />
                            <br />
                            <asp:CompareValidator ID="CompareValidatorPatientEmergedDateDOB" runat="server" ControlToValidate="PatientEmergedDate:TextBoxDate"
                                ControlToCompare="TextBoxDateOfBirth" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="GreaterThanEqual"
                                ErrorMessage="PRC Tracking - Date Patient Emerged needs to be later than Date of Birth." Display="Dynamic" Type="Date" />
                            <asp:CompareValidator ID="CompareValidatorPatientEmergedDateDOD" runat="server" ControlToValidate="PatientEmergedDate:TextBoxDate"
                                ControlToCompare="TextBoxDateOfDeath" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="LessThanEqual"
                                ErrorMessage="PRC Tracking - Date Patient Emerged needs to be less than or equal to Date of Death." Display="Dynamic" Type="Date" />
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            <asp:Label ID="LabelForJFKComaRecoveryScale" runat="server" AssociatedControlID="ddlJFKComaRecoveryScale">
                                JFK Coma Recovery Scale:
                            </asp:Label><br />
                            <asp:DropDownList ID="ddlJFKComaRecoveryScale" runat="server" TabIndex="190">
                                <asp:ListItem Text="0" Value="0" Selected="True" />
                                <asp:ListItem Text="1" Value="1" />
                                <asp:ListItem Text="2" Value="2" />
                                <asp:ListItem Text="3" Value="3" />
                                <asp:ListItem Text="4" Value="4" />
                                <asp:ListItem Text="5" Value="5" />
                                <asp:ListItem Text="6" Value="6" />
                                <asp:ListItem Text="7" Value="7" />
                                <asp:ListItem Text="8" Value="8" />
                                <asp:ListItem Text="9" Value="9" />
                                <asp:ListItem Text="10" Value="10" />
                                <asp:ListItem Text="11" Value="11" />
                                <asp:ListItem Text="12" Value="12" />
                                <asp:ListItem Text="13" Value="13" />
                                <asp:ListItem Text="14" Value="14" />
                                <asp:ListItem Text="15" Value="15" />
                                <asp:ListItem Text="16" Value="16" />
                                <asp:ListItem Text="17" Value="17" />
                                <asp:ListItem Text="18" Value="18" />
                                <asp:ListItem Text="19" Value="19" />
                                <asp:ListItem Text="20" Value="20" />
                                <asp:ListItem Text="21" Value="21" />
                                <asp:ListItem Text="22" Value="22" />
                                <asp:ListItem Text="23" Value="23" />
                            </asp:DropDownList>
                        </td>
                        <td class="style17" style="width: 50%">
                            <asp:Label ID="LabelForGenitoUrinaryInjuries" runat="server" AssociatedControlID="rblGenitoUrinaryInjuries">
                                Genito-Urinary Injuries <span class="requiredField">*</span>:
                            </asp:Label><br />
                            <asp:RadioButtonList ID="rblGenitoUrinaryInjuries" runat="server" RepeatDirection="Horizontal" TabIndex="191" ValidationGroup="OnSave">
                                <asp:ListItem Text="Yes" Value="1" />
                                <asp:ListItem Text="No" Value="0" />
                            </asp:RadioButtonList>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorGenitoUrinaryInjuries" runat="server" ControlToValidate="rblGenitoUrinaryInjuries"
                                TabIndex="192" ErrorMessage="PRC Tracking - Genito-Urinary Injuries Response is required" ValidationGroup="OnSave" SetFocusOnError="true"
                                Display="Static">
                            </asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="100%" style="width: 100%;">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            <asp:Label ID="LabelforTextBoxAdmissionFIMScore" runat="server" AssociatedControlID="TextBoxAdmissionFIMScore">
                                Admission FIM Score (18 - 126):
                            </asp:Label>
                            <br />
                            <asp:TextBox ID="TextBoxAdmissionFIMScore" runat="server" TabIndex="193" MaxLength="3" Width="50px" />
                            <asp:RangeValidator ID="RangeValidatorAdmissionFIMScore" runat="server" TabIndex="194" ControlToValidate="TextBoxAdmissionFIMScore"
                                ErrorMessage="PRC Tracking - FIM Score must be a number between 18 and 126." MaximumValue="126" MinimumValue="18" SetFocusOnError="true"
                                ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                            </asp:RangeValidator>
                        </td>
                        <td style="width: 50%">
                            <asp:HiddenField ID="HiddenFieldCurrentDate" runat="server" Visible="false" />
                            <asp:Label ID="LabelforTextBoxRehabAdmitDate" runat="server" AssociatedControlID="RehabAdmitDate:TextBoxDate"> 
                                 Admission Date (mm/dd/yyyy) <span class="requiredField">*</span>:
                            </asp:Label>
                            <br />
                            <UserControlDate:Date ID="RehabAdmitDate" runat="server" CssClass="staylength" ToDate="true" StartTabIndex="195" ErrorMessage="PRC Tracking - Admission Date: format (mm/dd/yyyy): no later than today"
                                ValidationGroup="OnSave" />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorAdmitDate" runat="server" TabIndex="205" ControlToValidate="RehabAdmitDate:TextBoxDate"
                                ErrorMessage="PRC Tracking - Admission Date is required" ValidationGroup="OnSave" Display="Dynamic">
                            </asp:RequiredFieldValidator>
                            <asp:CompareValidator ID="CompareValidatorRehabAdmitDateDOB" runat="server" ControlToValidate="RehabAdmitDate:TextBoxDate"
                                ControlToCompare="TextBoxDateOfBirth" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="GreaterThanEqual"
                                ErrorMessage="PRC Tracking - Admission Date needs to be later than Date of Birth." Display="Dynamic" Type="Date" />
                            <asp:CompareValidator ID="CompareValidatorRehabAdmitDateDOD" runat="server" ControlToValidate="RehabAdmitDate:TextBoxDate"
                                ControlToCompare="TextBoxDateOfDeath" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="LessThanEqual"
                                ErrorMessage="PRC Tracking - Admission Date needs to be less than or equal to Date of Death." Display="Dynamic" Type="Date" />
                            <asp:CompareValidator ID="CompareValidatorRehabAdmitDateCurrentDate" runat="server" ControlToValidate="RehabAdmitDate:TextBoxDate"
                                SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="LessThanEqual"
                                ErrorMessage="PRC Tracking - Admission Date needs to be less than or equal to today's date." Display="Dynamic" Type="Date" />
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            &nbsp;
                        </td>
                        <td class="style17" style="width: 50%">
                            <br />
                            <asp:Label ID="LabelDaysFromOnsetHeading" runat="server" AssociatedControlID="LabelDaysFromOnsetValue" SkinID="DataLabel">Days from Onset:
                            </asp:Label>&nbsp;
                            <asp:Label ID="LabelDaysFromOnsetValue" runat="server" Text="" SkinID="DataLabel">
                            </asp:Label>
                            <asp:Label ID="lblDaysFromOnsetDesc" runat="server" />
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            <asp:Label ID="LabelforDropDownListFRGCode" runat="server" AssociatedControlID="DropDownListFRGCode">
                                FRG Code:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListFRGCode" runat="server" AppendDataBoundItems="true" TabIndex="206" DataSourceID="ObjectDataSourceFRG"
                                DataTextField="NAME" DataValueField="ID">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td style="width: 50%">
                            <asp:Label ID="LabelforTextBoxDaysOffUnit" runat="server" AssociatedControlID="TextBoxDaysOffUnit">
                                Number of days off unit:
                            </asp:Label>
                            <br />
                            <asp:TextBox ID="TextBoxDaysOffUnit" runat="server" CssClass="staylength" TabIndex="207" MaxLength="5" Width="50px">
                            </asp:TextBox>
                            <br />
                            <asp:RangeValidator ID="RangeValidatorDaysOffUnit" runat="server" TabIndex="208" ControlToValidate="TextBoxDaysOffUnit" ErrorMessage="PRC Tracking - Days Off Unit must be zero or a positive integer."
                                MaximumValue="99999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Static">
                            </asp:RangeValidator>
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 50%">
                            <asp:Label ID="LabelforTextBoxDischargeFIMScore" runat="server" AssociatedControlID="TextBoxDischargeFIMScore">Discharge FIM Score (18 - 126):
                            </asp:Label>
                            <br />
                            <asp:TextBox ID="TextBoxDischargeFIMScore" runat="server" TabIndex="210" MaxLength="3" Width="50px" />
                            <br />
                            <asp:RangeValidator ID="RangeValidatorDischargeFIMScore" runat="server" TabIndex="211" SetFocusOnError="true" ValidationGroup="OnSave"
                                ControlToValidate="TextBoxDischargeFIMScore" ErrorMessage="PRC Tracking - FIM Score must be a number between 18 and 126." MaximumValue="126"
                                MinimumValue="18" Type="Integer" Display="Static">
                            </asp:RangeValidator>
                        </td>
                        <td style="width: 50%">
                            <asp:Label ID="LabelforTextBoxRehabDischargeDate" runat="server" AssociatedControlID="RehabDischargeDate:TextBoxDate"> 
                                 Rehab Discharge Date (mm/dd/yyyy):
                            </asp:Label>
                            <br />
                            <UserControlDate:Date ID="RehabDischargeDate" runat="server" CssClass="staylength" ToDate="true" StartTabIndex="215" ErrorMessage="PRC Tracking - Rehab Discharge Date needs to be a valid date in format (mm/dd/yyyy) and not later than today."
                                ValidationGroup="OnSave" />
                            <br />
                            <asp:CompareValidator ID="CompareValidatorTextBoxDateScheduledWithTBIEvaluationTeamMax" runat="server" ControlToValidate="RehabDischargeDate:TextBoxDate"
                                ControlToCompare="RehabAdmitDate:TextBoxDate" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true"
                                Operator="GreaterThanEqual" ErrorMessage="PRC Tracking - Rehab Discharge Date needs to be later than Admission Date." Display="Dynamic"
                                Type="Date" />
                            <asp:CompareValidator ID="CompareValidatorRehabDischargeDateDOB" runat="server" ControlToValidate="RehabDischargeDate:TextBoxDate"
                                ControlToCompare="TextBoxDateOfBirth" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="GreaterThanEqual"
                                ErrorMessage="PRC Tracking - Rehab Discharge Date needs to be later than Date of Birth." Display="Dynamic" Type="Date" />
                            <asp:CompareValidator ID="CompareValidatorRehabDischargeDateDOD" runat="server" ControlToValidate="RehabDischargeDate:TextBoxDate"
                                ControlToCompare="TextBoxDateOfDeath" SetFocusOnError="true" ValidationGroup="OnSave" EnableClientScript="true" Operator="LessThanEqual"
                                ErrorMessage="PRC Tracking - Rehab Discharge Date needs to be less than or equal to Date of Death." Display="Dynamic" Type="Date" />
                        </td>
                    </tr>
                    <tr runat="server" id="trPRCFollowupDate">
                        <td style="width: 50%">&nbsp;</td>
                        <td style="width: 50%">
                            <asp:Label ID="LabelforTextBoxPRCFollowupDate" runat="server" AssociatedControlID="PRCFollowupDate:TextBoxDate"> 
                                 Follow-Up Date (mm/dd/yyyy):
                            </asp:Label>
                            <br />
                            <UserControlDate:Date ID="PRCFollowupDate" runat="server" ToDate="true" StartTabIndex="225" 
                                    ErrorMessage="PRC Tracking - PRC Follow Up Date needs to be a valid date in format (mm/dd/yyyy) and not later than today."
                                    ValidationGroup="OnSave" />
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            <asp:Label ID="LabelforLabelAgeAtAdmission" runat="server" AssociatedControlID="LabelAgeAtAdmission" SkinID="DataLabel">Age at Admission:
                            </asp:Label>&nbsp;
                            <asp:Label ID="LabelAgeAtAdmission" runat="server" Text="Age at Admission" SkinID="DataLabel">
                            </asp:Label>
                            <br />
                            <br />
                        </td>
                        <td style="width: 50%">
                            <asp:Label ID="LabelLOSHeading" runat="server" AssociatedControlID="LabelLOSValue" SkinID="DataLabel">LOS:
                            </asp:Label>&nbsp;
                            <asp:Label ID="LabelLOSValue" runat="server" Text="LOS Value" SkinID="DataLabel">
                            </asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            <asp:Label ID="LabelforDropDownListRehabDischargedTo" runat="server" AssociatedControlID="DropDownListRehabDischargedTo">Discharged To:
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListRehabDischargedTo" runat="server" TabIndex="235" AppendDataBoundItems="true" DataSourceID="ObjectDataSourceRehabDischargeTo"
                                DataTextField="NAME" DataValueField="ID">
                                <asp:ListItem Value="">-- Select a Value --</asp:ListItem>
                            </asp:DropDownList>
                            &nbsp;<asp:Label ID="lblDischargeTo" runat="server" Text="" Visible="False"></asp:Label>
                            &nbsp;<asp:Label ID="lblInactiveValue" runat="server" Text="(Inactive value)" CssClass="redText" Visible="False"></asp:Label>
                            &nbsp;<asp:LinkButton ID="lnkbtnChangeDischargeTo" runat="server" onclick="lnkbtnChangeDischargeTo_Click" Visible="False">Change</asp:LinkButton>
                            &nbsp;<asp:LinkButton ID="lnkbtnKeepInactiveDischargeToCode" runat="server" onclick="lnkbtnKeepInactiveDischargeToCode_Click" Visible="False">Cancel (keep inactive value)</asp:LinkButton>
                        </td>
                    </tr>
                </table>
                <table class="style1">
                    <tr>
                        <td>
                            <asp:Panel ID="PanelFollowUpClinicalNeeds" runat="server" GroupingText="Follow Up Clinical Needs&nbsp;&nbsp;" BorderStyle="None">
                                <asp:CheckBoxList ID="CheckBoxListFollowUps" runat="server" CellSpacing="2" TabIndex="236" DataSourceID="ObjectDataSourceFollowUpList"
                                    DataTextField="NAME" DataValueField="ID" RepeatColumns="4" RepeatDirection="Horizontal" RepeatLayout="Table">
                                </asp:CheckBoxList>
                            </asp:Panel>
                        </td>
                    </tr>
                </table>
                <table class="style1">
                    <tr>
                        <td>
                            <asp:Label ID="LabelforTextBoxFollowupSiteDescription" runat="server" AssociatedControlID="TextBoxFollowupSiteDescription">
                                Follow-Up Site Description:
                            </asp:Label>
                            <br />
                            <asp:TextBox ID="TextBoxFollowupSiteDescription" runat="server" TabIndex="240" MaxLength="255" Rows="3" TextMode="MultiLine"
                                Width="99%" />
                            <asp:RegularExpressionValidator ID="FollowupSiteDescriptionValidator" runat="server" TabIndex="241" ControlToValidate="TextBoxFollowupSiteDescription"
                                ErrorMessage="PRC Tracking - Follow Up Site Description needs to be less than 255 characters." ValidationGroup="OnSave" ValidationExpression="^[\s\S]{0,255}$"
                                SetFocusOnError="true" Display="Static">
                            </asp:RegularExpressionValidator>
                        </td>
                    </tr>
                </table>
                <br />
                <asp:Panel ID="PanelProvider" runat="server" GroupingText="Follow Up Provider Information&nbsp;&nbsp;" Width="99%">
                    <table class="style1">
                        <tr>
                            <td class="style18">
                                <asp:Label ID="LabelforTextBoxProviderName" runat="server" AssociatedControlID="TextBoxProviderName">
                                    Follow Up Polytrauma Case Manager:
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="TextBoxProviderName" runat="server" MaxLength="100" TabIndex="242" Width="240px" />
                            </td>
                            <td>
                                <asp:Label ID="LabelforDropDownListProviderLocation" runat="server" AssociatedControlID="TextBoxFollowupProviderLocation">
                                    Location:
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="TextBoxFollowupProviderLocation" runat="server" TabIndex="243" Width="300px">
                                </asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            </td>
                        </tr>
                        <tr>
                            <td class="style18">
                                <asp:Label ID="LabelforTextBoxProviderPhone" runat="server" AssociatedControlID="TextBoxProviderPhone">
                                    Phone:
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="TextBoxProviderPhone" runat="server" TabIndex="250" MaxLength="30" Width="100px" />
                            </td>
                            <td>
                                <asp:Label ID="LabelforTextBoxProviderEmail" runat="server" AssociatedControlID="TextBoxProviderEmail">Email:
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="TextBoxProviderEmail" runat="server" TabIndex="251" MaxLength="128" Width="250px" />
                                <br />
                                <asp:RegularExpressionValidator ID="RegularExpressionValidatorProviderEmail" runat="server" TabIndex="255" SetFocusOnError="true"
                                    ControlToValidate="TextBoxProviderEmail" ErrorMessage="PRC Tracking - Follow Up Provider Information - Email is invalid" ValidationExpression="^\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*$"
                                    ValidationGroup="OnSave" Display="Static">
                                </asp:RegularExpressionValidator>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <br />
            </asp:Panel>
            <br />
            &nbsp;
            <asp:Button ID="ButtonSave" runat="server" TabIndex="260" ValidationGroup="OnSave" Text="  Save  " OnClick="ButtonSave_Click" />
            &nbsp;&nbsp;
            <asp:Button ID="ButtonClose" runat="server" TabIndex="261" SkinID="CloseButton" UseSubmitBehavior="false" OnClick="ButtonClose_Click" />
            &nbsp;&nbsp;
            <asp:Button ID="btnDelete" runat="server" TabIndex="262" SkinID="" UseSubmitBehavior="false" Text="Delete" OnClick="btnDelete_Click"
                    OnClientClick="if(!DeleteConfirmation()) return false;" />
            <br />
            <br />
        </asp:Panel>
        <asp:Panel ID="PanelSSNExists" runat="server" BorderColor="Red" BorderStyle="Solid" BorderWidth="1" Visible="false" Width="100%">
            <table border="0">
                <tr>
                    <td>
                        <asp:Label ID="LabelSSNExistsWarning" runat="server" ForeColor="Red" AssociatedControlID="LabelSSNExistsWarningText" SkinID="DataLabel">Warning SSN Exists</asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelSSNExistsWarningText" runat="server" SkinID="DataLabel">
                                 A record in the polytrauma registry has the same Social Security Number as the one you entered.  
                                Social Security Numbers should be unique per patient.  However, it is possible for Patients to have multiple 
                                entries in the system for each polytrauma center admission.
                                <br /><br />Click "Accept SSN" if this is an additional admission for the patient or correct the SSN number above and click "Save" again.
                        </asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Button ID="ButtonContinueWithSSNChange" runat="server" TabIndex="263" OnClick="ButtonContinueWithSSNChange_Click" Text=" Accept SSN " />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelPTRP" runat="server" GroupingText="PTRP Tracking&nbsp;&nbsp;" Width="100%">
            &nbsp;<asp:Button runat="server" ID="ShowPRCPanelButton" OnClick="ShowPRCPanelButtonClick" Text="Switch to PRC Tracking" style="background-color:White;color:Gray;border: solid 1px LightGray;position:relative;left:100px;top:-20px;border-radius:5px;padding:3px;cursor:pointer;font-size:8pt;" />
            <table cellpadding="5" cellspacing="5" style="position:relative;top:-20px;">
                <tr>
                    <td colspan="2">
                        <!-- Form Item #1 -->
                        <asp:Label ID="LabelForPTRPProgram" runat="server" AssociatedControlID="rblSeverityLevelIndexTBI">
                            Program <span class="requiredField">*</span>:
                        </asp:Label>
                        <br />
                        <asp:RadioButtonList ID="rblPTRPProgram" runat="server" RepeatDirection="Horizontal" ValidationGroup="OnSave" TabIndex="320">
                            <asp:ListItem Text="Inpatient" Value="Inpatient" />
                            <asp:ListItem Text="Day" Value="Day" />
                        </asp:RadioButtonList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorPTRPProgram" ControlToValidate="rblPTRPProgram" TabIndex="321" ValidationGroup="OnSave"
                            Display="Dynamic" runat="server" EnableClientScript="true" ErrorMessage="PTRP Tracking - PTRP Program is required." SetFocusOnError="true">
                        </asp:RequiredFieldValidator>
                        <!-- End Form Item #1 -->
                    </td>
                </tr>
                <tr>
                    <td class="style17" style="width: 50%">
                        <!-- Form Item #2 -->
                        <asp:Label ID="LabelForPTRPPreinjuryPrimaryPersonLivingWith" runat="server" AssociatedControlID="ddlPTRPPreinjuryPrimaryPersonLivingWith">
                            Preinjury Primary Person Living with <span class="requiredField">*</span>:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="ddlPTRPPreinjuryPrimaryPersonLivingWith" runat="server" TabIndex="322" DataSourceID="ObjectDataSourcePTRPPreinjuryPrimaryPersonLivingWith"
                            DataTextField="NAME" DataValueField="ID" AppendDataBoundItems="true">
                            <asp:ListItem Text="" />
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorPTRPPreinjuryPrimaryPersonLivingWith" ControlToValidate="ddlPTRPPreinjuryPrimaryPersonLivingWith"
                            TabIndex="323" ValidationGroup="OnSave" Display="Dynamic" runat="server" EnableClientScript="true" ErrorMessage="PTRP Tracking - PTRP Preinjury Living With is required."
                            SetFocusOnError="true">
                        </asp:RequiredFieldValidator>
                        <!-- End Form Item #2 -->
                    </td>
                    <td class="style17" style="width: 50%">
                        <!-- Form Item #3 -->
                        <asp:Label ID="LabelForPTRPPreinjuryResidence" runat="server" AssociatedControlID="ddlPTRPPreinjuryResidence">
                            Preinjury Residence <span class="requiredField">*</span>:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="ddlPTRPPreinjuryResidence" runat="server" DataSourceID="ObjectDataSourceRehabDischargeTo" DataTextField="NAME"
                            DataValueField="ID" AppendDataBoundItems="true" TabIndex="324">
                            <asp:ListItem Text="" />
                        </asp:DropDownList>
                        <br />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorPTRPPreinjuryResidence" ControlToValidate="ddlPTRPPreinjuryResidence"
                            TabIndex="325" ValidationGroup="OnSave" Display="Dynamic" runat="server" EnableClientScript="true" ErrorMessage="PTRP Tracking - PTRP Preinjury Residence is required."
                            SetFocusOnError="true">
                        </asp:RequiredFieldValidator>
                        <!-- End Form Item #3 -->
                    </td>
                </tr>
                <tr>
                    <td class="style17" style="width: 50%">
                        <!-- Form Item #4 -->
                        <asp:Label ID="LabelForPTRPPreinjuryPriEmployStatus" runat="server" AssociatedControlID="ddlPTRPPreinjuryPriEmployStatus">
                            Primary Preinjury Employment Status:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="ddlPTRPPreinjuryPriEmployStatus" runat="server" DataSourceID="ObjectDataSourceEmploymentStatus" DataTextField="NAME"
                            DataValueField="ID" AppendDataBoundItems="true" TabIndex="326">
                            <asp:ListItem Text="" />
                        </asp:DropDownList>
                        <!-- End Form Item #4 -->
                    </td>
                    <td class="style17" style="width: 50%">
                        <!-- Form Item #5 -->
                        <asp:Label ID="LabelForPTRPPreinjurySecEmployStatus" runat="server" AssociatedControlID="ddlPTRPPreinjurySecEmployStatus">
                            Secondary Preinjury Employment Status:
                        </asp:Label>
                        <br />
                        <asp:DropDownList ID="ddlPTRPPreinjurySecEmployStatus" runat="server" DataSourceID="ObjectDataSourceEmploymentStatus" DataTextField="NAME"
                            DataValueField="ID" AppendDataBoundItems="true" TabIndex="327">
                            <asp:ListItem Text="" />
                        </asp:DropDownList>
                        <!-- End Form Item #5 -->
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%">
                        <asp:Label ID="LabelforTextBoxPTRPAdmissionDate" runat="server" AssociatedControlID="PTRPAdmissionDate:TextBoxDate"> 
                             Admission Date (mm/dd/yyyy):
                        </asp:Label>
                        <br />
                        <UserControlDate:Date ID="PTRPAdmissionDate" runat="server" ToDate="true" StartTabIndex="328" 
                                ErrorMessage="PTRP Tracking - PTRP Admission Date needs to be a valid date in format (mm/dd/yyyy) and not later than today."
                                ValidationGroup="OnSave" />
                    </td>
                    <td style="width: 50%">
                        <asp:Label ID="LabelforTextBoxPTRPDischargeDate" runat="server" AssociatedControlID="PTRPDischargeDate:TextBoxDate"> 
                             Discharge Date (mm/dd/yyyy):
                        </asp:Label>
                        <br />
                        <UserControlDate:Date ID="PTRPDischargeDate" runat="server" ToDate="true" StartTabIndex="330" 
                                ErrorMessage="PTRP Tracking - PTRP Discharge Date needs to be a valid date in format (mm/dd/yyyy) and not later than today."
                                ValidationGroup="OnSave" />
                    </td>
                </tr>
                <tr runat="server" id="trPTRPFollowupDate">
                        <td style="width: 50%">&nbsp;</td>
                        <td style="width: 50%">
                            <asp:Label ID="LabelforTextBoxPTRPFollowupDate" runat="server" AssociatedControlID="PTRPFollowupDate:TextBoxDate"> 
                                 Follow-Up Date (mm/dd/yyyy):
                            </asp:Label>
                            <br />
                            <UserControlDate:Date ID="PTRPFollowupDate" runat="server" ToDate="true" StartTabIndex="340" 
                                    ErrorMessage="PTRP Tracking - PTRP Follow Up Date needs to be a valid date in format (mm/dd/yyyy) and not later than today."
                                    ValidationGroup="OnSave" />
                        </td>
                </tr>
                <tr>
                    <td style="width: 100%;" colspan="2">
                        <br />
                        <asp:Panel ID="pnlMPAIScoresArea" runat="server" GroupingText="MPAI (T scores from National Sample Staff rating in MPAI-4 manual)&nbsp;&nbsp;">
                            <table style="width: 100%;" cellpadding="3">
                                <tr>
                                    <td colspan="2" style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Abilities
                                    </td>
                                    <td colspan="2" style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Adjustment
                                    </td>
                                    <td colspan="2" style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Participation
                                    </td>
                                    <td colspan="2" style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Total
                                    </td>
                                </tr>
                                <tr>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #6 -->
                                        <asp:Label ID="LabelForMPAIAbilitiesInitial" runat="server" AssociatedControlID="txtMPAIAbilitiesInitial">
                                        Initial:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIAbilitiesInitial" runat="server" MaxLength="4" Width="40px" TabIndex="342" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIAbilitiesInitial" runat="server" TabIndex="343" ControlToValidate="txtMPAIAbilitiesInitial"
                                            ErrorMessage="PTRP Tracking - MPAI Abilities Initial must be between -4 to 109" MaximumValue="109" MinimumValue="-4" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #6 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #7 -->
                                        <asp:Label ID="LabelForMPAIAbilitiesDischarge" runat="server" AssociatedControlID="txtMPAIAbilitiesDischarge">
                                        Discharge:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIAbilitiesDischarge" runat="server" MaxLength="4" Width="40px" TabIndex="350" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIAbilitiesDischarge" runat="server" TabIndex="351" ControlToValidate="txtMPAIAbilitiesDischarge"
                                            ErrorMessage="PTRP Tracking - MPAI Abilities Discharge must be between -4 to 109" MaximumValue="109" MinimumValue="-4" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #7 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #8 -->
                                        <asp:Label ID="LabelForMPAIAdjustmentInitial" runat="server" AssociatedControlID="txtMPAIAdjustmentInitial">
                                        Initial:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIAdjustmentInitial" runat="server" MaxLength="4" Width="40px" TabIndex="352" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIAdjustmentInitial" runat="server" TabIndex="353" ControlToValidate="txtMPAIAdjustmentInitial"
                                            ErrorMessage="PTRP Tracking - MPAI Adjustment Initial must be between -6 to 94" MaximumValue="94" MinimumValue="-6" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #8 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #9 -->
                                        <asp:Label ID="LabelForMPAIAdjustmentDischarge" runat="server" AssociatedControlID="txtMPAIAdjustmentDischarge">
                                        Discharge:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIAdjustmentDischarge" runat="server" MaxLength="4" Width="40px" TabIndex="354" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIAdjustmentDischarge" runat="server" TabIndex="355" ControlToValidate="txtMPAIAdjustmentDischarge"
                                            ErrorMessage="PTRP Tracking - MPAI Adjustment Discharge must be between -6 to 94" MaximumValue="94" MinimumValue="-6" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #9 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #10 -->
                                        <asp:Label ID="LabelForMPAIParticipationInitial" runat="server" AssociatedControlID="txtMPAIParticipationInitial">
                                        Initial:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIParticipationInitial" runat="server" MaxLength="4" Width="40px" TabIndex="356" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIParticipationInitial" runat="server" TabIndex="357" ControlToValidate="txtMPAIParticipationInitial"
                                            ErrorMessage="PTRP Tracking - MPAI Participation Initial must be between 7 to 74" MaximumValue="74" MinimumValue="7" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #10 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #11 -->
                                        <asp:Label ID="LabelForMPAIParticipationDischarge" runat="server" AssociatedControlID="txtMPAIParticipationDischarge">
                                        Discharge:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIParticipationDischarge" runat="server" MaxLength="4" Width="40px" TabIndex="358" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIParticipationDischarge" runat="server" TabIndex="359" ControlToValidate="txtMPAIParticipationDischarge"
                                            ErrorMessage="PTRP Tracking - MPAI Participation Discharge must be between 7 to 74" MaximumValue="74" MinimumValue="7" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #11 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #12 -->
                                        <asp:Label ID="LabelForMPAITotalInitial" runat="server" AssociatedControlID="txtMPAITotalInitial">
                                        Initial:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAITotalInitial" runat="server" MaxLength="4" Width="40px" TabIndex="360" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAITotalInitial" runat="server" TabIndex="361" ControlToValidate="txtMPAITotalInitial"
                                            ErrorMessage="PTRP Tracking - MPAI Total Initial must be between -38 to 106" MaximumValue="106" MinimumValue="-38" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #12 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #13 -->
                                        <asp:Label ID="LabelForMPAITotalDischarge" runat="server" AssociatedControlID="txtMPAITotalDischarge">
                                        Discharge:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAITotalDischarge" runat="server" MaxLength="4" Width="40px" TabIndex="362" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAITotalFollowUp" runat="server" TabIndex="363" ControlToValidate="txtMPAITotalDischarge"
                                            ErrorMessage="PTRP Tracking - MPAI Total Discharge must be between -38 to 106" MaximumValue="106" MinimumValue="-38" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #13 -->
                                    </td>
                                </tr>
                            </table>
                        </asp:Panel>
                        <asp:Panel ID="pnlMPAIFollowUpScoresArea" runat="server" GroupingText="MPAI (T scores from National Sample Staff rating in MPAI-4 manual)&nbsp;&nbsp;"
                            Visible="false">
                            <table style="width: 100%;" cellpadding="3">
                                <tr>
                                    <td style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Abilities
                                    </td>
                                    <td style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Adjustment
                                    </td>
                                    <td style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Participation
                                    </td>
                                    <td style="font-weight: bold; width: 25%; border-bottom: 1px solid #CCCCCC;">
                                        Total
                                    </td>
                                </tr>
                                <tr>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #7 -->
                                        <asp:Label ID="LabelForMPAIAbilitiesFollowup" runat="server" AssociatedControlID="txtMPAIAbilitiesFollowup">
                                        Follow-Up:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIAbilitiesFollowup" runat="server" MaxLength="4" Width="40px" TabIndex="370" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIAbilitiesFollowup" runat="server" TabIndex="371" ControlToValidate="txtMPAIAbilitiesFollowup"
                                            ErrorMessage="PTRP Tracking - MPAI Abilities Follow-Up must be between -4 to 109" MaximumValue="109" MinimumValue="-4" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #7 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #9 -->
                                        <asp:Label ID="LabelForMPAIAdjustmentFollowUp" runat="server" AssociatedControlID="txtMPAIAdjustmentFollowUp">
                                        Follow-Up:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIAdjustmentFollowUp" runat="server" MaxLength="4" Width="40px" TabIndex="373" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIAdjustmentFollowUp" runat="server" TabIndex="374" ControlToValidate="txtMPAIAdjustmentFollowUp"
                                            ErrorMessage="PTRP Tracking - MPAI Adjustment Follow-Up must be between -6 to 94" MaximumValue="94" MinimumValue="-6" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #9 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #11 -->
                                        <asp:Label ID="LabelForMPAIParticipationFollowUp" runat="server" AssociatedControlID="txtMPAIParticipationFollowUp">
                                        Follow-Up:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAIParticipationFollowUp" runat="server" MaxLength="4" Width="40px" TabIndex="377" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidatorMPAIParticipationFollowUp" runat="server" TabIndex="378" ControlToValidate="txtMPAIParticipationFollowUp"
                                            ErrorMessage="PTRP Tracking - MPAI Participation Follow-Up must be between 7 to 74" MaximumValue="74" MinimumValue="7" SetFocusOnError="true"
                                            ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #11 -->
                                    </td>
                                    <td style="vertical-align: top;">
                                        <!-- Form Item #13 -->
                                        <asp:Label ID="LabelForMPAITotalFollowUp" runat="server" AssociatedControlID="txtMPAITotalFollowUp">
                                        Follow-Up:
                                        </asp:Label><br />
                                        <asp:TextBox ID="txtMPAITotalFollowUp" runat="server" MaxLength="4" Width="40px" TabIndex="380" />
                                        <br />
                                        <asp:RangeValidator ID="RangeValidator1" runat="server" TabIndex="383" ControlToValidate="txtMPAITotalFollowUp" ErrorMessage="PTRP Tracking - MPAI Total Follow-Up must be between -38 to 106"
                                            MaximumValue="106" MinimumValue="-38" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                        </asp:RangeValidator>
                                        <!-- End Form Item #13 -->
                                    </td>
                                </tr>
                            </table>
                        </asp:Panel>
                    </td>
                </tr>
                <asp:Panel ID="pnlMPAIQ26_SWLSAdmissionArea" runat="server" Visible="true">
                    <tr>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #14 -->
                            <asp:Label ID="LabelForMPAIQuestion26ResidenceAdmission" runat="server" AssociatedControlID="rblMPAIQuestion26ResidenceAdmission">
                            MPAI Question #26  Residence (Admission)
                            </asp:Label>
                            <br />
                            <asp:RadioButtonList ID="rblMPAIQuestion26ResidenceAdmission" runat="server" RepeatDirection="Vertical" TabIndex="390">
                                <asp:ListItem Text="Independent; living without supervision or concern from others" Value="0" />
                                <asp:ListItem Text="Living without supervision but others have concerns about safety or managing responsibilities" Value="1" />
                                <asp:ListItem Text="Requires a little assistance or supervision from others ( 5-24% of the time)" Value="2" />
                                <asp:ListItem Text="Requires moderate assistance or supervision from others (25-75% of the time)" Value="3" />
                                <asp:ListItem Text="Requires extensive assistance or supervision from others (more than 75% of the time)" Value="4" />
                            </asp:RadioButtonList>
                            <!-- End Form Item #14 -->
                        </td>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #15 -->
                            <asp:Label ID="LabelForMPAIQuestion26ResidenceDischarge" runat="server" AssociatedControlID="rblMPAIQuestion26ResidenceDischarge">
                            MPAI Question #26  Residence (Discharge)
                            </asp:Label>
                            <br />
                            <asp:RadioButtonList ID="rblMPAIQuestion26ResidenceDischarge" runat="server" RepeatDirection="Vertical" TabIndex="391">
                                <asp:ListItem Text="Independent; living without supervision or concern from others" Value="0" />
                                <asp:ListItem Text="Living without supervision but others have concerns about safety or managing responsibilities" Value="1" />
                                <asp:ListItem Text="Requires a little assistance or supervision from others ( 5-24% of the time)" Value="2" />
                                <asp:ListItem Text="Requires moderate assistance or supervision from others (25-75% of the time)" Value="3" />
                                <asp:ListItem Text="Requires extensive assistance or supervision from others (more than 75% of the time)" Value="4" />
                            </asp:RadioButtonList>
                            <!-- End Form Item #15 -->
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #16 -->
                            <asp:Label ID="LabelForSatisfactionWithLifeInitial" runat="server" AssociatedControlID="txtSatisfactionWithLifeInitial">
                            Satisfaction with Life (Admission):
                            </asp:Label><br />
                            <asp:TextBox ID="txtSatisfactionWithLifeInitial" runat="server" MaxLength="2" TabIndex="395" />
                            <br />
                            <asp:RangeValidator ID="RangeValidatorSatisfactionWithLifeInitial" runat="server" TabIndex="396" ControlToValidate="txtSatisfactionWithLifeInitial"
                                ErrorMessage="PTRP Tracking - Satisfaction with Life Initial must be between 5 to 35" MaximumValue="35" MinimumValue="5" SetFocusOnError="true"
                                ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                            </asp:RangeValidator>
                            <!-- End Form Item #16 -->
                        </td>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #17 -->
                            <asp:Label ID="LabelForSatisfactionWithLifeDischarge" runat="server" AssociatedControlID="txtSatisfactionWithLifeDischarge">
                            Satisfaction with Life (Discharge):
                            </asp:Label><br />
                            <asp:TextBox ID="txtSatisfactionWithLifeDischarge" runat="server" MaxLength="2" TabIndex="397" />
                            <br />
                            <asp:RangeValidator ID="RangeValidatorSatisfactionWithLifeFollowUp" runat="server" TabIndex="398" ControlToValidate="txtSatisfactionWithLifeDischarge"
                                ErrorMessage="PTRP Tracking - Satisfaction with Life Discharge must be between 5 to 35" MaximumValue="35" MinimumValue="5" SetFocusOnError="true"
                                ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                            </asp:RangeValidator>
                            <!-- End Form Item #17 -->
                        </td>
                    </tr>
                </asp:Panel>
                <asp:Panel ID="pnlMPAIQ26_SWLSFollowUpArea" runat="server" Visible="false">
                    <tr>
                        <td class="style17" style="width: 100%" colspan="100%">
                            <!-- Form Item #15 -->
                            <asp:Label ID="LabelForMPAIQuestion26ResidenceFollowUp" runat="server" AssociatedControlID="rblMPAIQuestion26ResidenceFollowUp">
                            MPAI Question #26  Residence (Follow-Up)
                            </asp:Label>
                            <br />
                            <asp:RadioButtonList ID="rblMPAIQuestion26ResidenceFollowUp" runat="server" RepeatDirection="Vertical" TabIndex="410">
                                <asp:ListItem Text="Independent; living without supervision or concern from others" Value="0" />
                                <asp:ListItem Text="Living without supervision but others have concerns about safety or managing responsibilities" Value="1" />
                                <asp:ListItem Text="Requires a little assistance or supervision from others ( 5-24% of the time)" Value="2" />
                                <asp:ListItem Text="Requires moderate assistance or supervision from others (25-75% of the time)" Value="3" />
                                <asp:ListItem Text="Requires extensive assistance or supervision from others (more than 75% of the time)" Value="4" />
                            </asp:RadioButtonList>
                            <!-- End Form Item #15 -->
                        </td>
                    </tr>
                    <tr>
                        <td class="style17" style="width: 100%" colspan="100%">
                            <asp:Label ID="LabelForSatisfactionWithLifeFollowUp" runat="server" AssociatedControlID="txtSatisfactionWithLifeFollowUp">
                            Satisfaction with Life (Follow-Up):
                            </asp:Label><br />
                            <asp:TextBox ID="txtSatisfactionWithLifeFollowUp" runat="server" MaxLength="2" TabIndex="411" />
                            <br />
                            <asp:RangeValidator ID="RangeValidator3" runat="server" TabIndex="412" ControlToValidate="txtSatisfactionWithLifeFollowUp"
                                ErrorMessage="PTRP Tracking - Satisfaction with Life Initial must be between 5 to 35" MaximumValue="35" MinimumValue="5" SetFocusOnError="true"
                                ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                            </asp:RangeValidator>
                            <!-- End Form Item #17 -->
                        </td>
                    </tr>
                </asp:Panel>
                <tr>
                    <td class="style17" style="width: 50%">
                        <!-- Form Item #18 -->
                        <asp:Label ID="LabelForPARTFollowUp" runat="server" AssociatedControlID="txtPARTFollowUp">
                            Participation Assessment with Recombined Tools (PART):
                        </asp:Label><br />
                        <asp:TextBox ID="txtPARTFollowUp" runat="server" MaxLength="4" TabIndex="420" />
                        <br />
                        <asp:RangeValidator ID="RangeValidatorPARTFollowUp" runat="server" TabIndex="421" ControlToValidate="txtPARTFollowUp" ErrorMessage="PTRP Tracking - PART Follow-Up must be between 0 to 128"
                            MaximumValue="128" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                        </asp:RangeValidator>
                        <!-- End Form Item #18 -->
                    </td>
                    <td class="style17" style="width: 50%">
                        &nbsp;
                    </td>
                </tr>
                <asp:Panel ID="pnlPrimaryPersonLivingDischargeArea" runat="server">
                    <tr>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #20 -->
                            <asp:Label ID="LabelForPTRPDCPrimaryPersonLivingWith" runat="server" AssociatedControlID="ddlPTRPDCPrimaryPersonLivingWith">
                            Primary Person Living with (Discharge):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPDCPrimaryPersonLivingWith" runat="server" DataSourceID="ObjectDataSourcePTRPPreinjuryPrimaryPersonLivingWith"
                                DataTextField="NAME" DataValueField="ID" AppendDataBoundItems="true" TabIndex="430">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #20 -->
                        </td>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #22 -->
                            <asp:Label ID="LabelForPTRPFollowUpResidence" runat="server" AssociatedControlID="ddlPTRPDCResidence">
                            Residence (Discharge):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPDCResidence" runat="server" DataSourceID="ObjectDataSourceRehabDischargeToPTRP" DataTextField="NAME"
                                DataValueField="ID" AppendDataBoundItems="true" TabIndex="431">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #22 -->
                        </td>
                    </tr>
                </asp:Panel>
                <asp:Panel ID="pnlPrimaryPersonLivingFollowUpArea" runat="server" Visible="false">
                    <tr>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #21 -->
                            <asp:Label ID="LabelForPTRPRollowUpPrimaryPersonLivingWith" runat="server" AssociatedControlID="ddlPTRPFollowUpPrimaryPersonLivingWith">
                            Primary Person Living with (Follow-Up):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPFollowUpPrimaryPersonLivingWith" runat="server" DataSourceID="ObjectDataSourcePTRPPreinjuryPrimaryPersonLivingWith"
                                DataTextField="NAME" DataValueField="ID" AppendDataBoundItems="true" TabIndex="432">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #21 -->
                        </td>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #23 -->
                            <asp:Label ID="LabelForPTRPDCResidence" runat="server" AssociatedControlID="ddlPTRPFollowUpResidence">
                            Residence (Follow-Up):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPFollowUpResidence" runat="server" DataSourceID="ObjectDataSourceRehabDischargeToPTRP" DataTextField="NAME"
                                DataValueField="ID" AppendDataBoundItems="true" TabIndex="435">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #23 -->
                        </td>
                    </tr>
                </asp:Panel>
                <asp:Panel ID="pnlPrimaryEmploymentStatusDischargeArea" runat="server">
                    <tr>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #24 -->
                            <asp:Label ID="Label4" runat="server" AssociatedControlID="ddlPTRPDCPriEmployStatus">
                            Primary Employment Status (Discharge):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPDCPriEmployStatus" runat="server" DataSourceID="ObjectDataSourceEmploymentStatus" DataTextField="NAME"
                                DataValueField="ID" AppendDataBoundItems="true" TabIndex="441">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #24 -->
                        </td>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #25 -->
                            <asp:Label ID="Label6" runat="server" AssociatedControlID="ddlPTRPDCSecEmployStatus">
                            Secondary Employment Status (Discharge):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPDCSecEmployStatus" runat="server" DataSourceID="ObjectDataSourceEmploymentStatus" DataTextField="NAME"
                                DataValueField="ID" AppendDataBoundItems="true" TabIndex="442">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #25 -->
                        </td>
                    </tr>
                </asp:Panel>
                <asp:Panel ID="pnlPrimaryEmploymentStatusFollowUpArea" runat="server" Visible="false">
                    <tr>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #26 -->
                            <asp:Label ID="Label5" runat="server" AssociatedControlID="ddlPTRPFollowUpPriEmployStatus">
                            Primary Employment Status (Follow-Up):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPFollowUpPriEmployStatus" runat="server" DataSourceID="ObjectDataSourceEmploymentStatus" DataTextField="NAME"
                                DataValueField="ID" AppendDataBoundItems="true" TabIndex="443">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #26 -->
                        </td>
                        <td class="style17" style="width: 50%">
                            <!-- Form Item #27 -->
                            <asp:Label ID="Label7" runat="server" AssociatedControlID="ddlPTRPFollowUpSecEmployStatus">
                            Secondary Employment Status (Follow-Up):
                            </asp:Label>
                            <br />
                            <asp:DropDownList ID="ddlPTRPFollowUpSecEmployStatus" runat="server" DataSourceID="ObjectDataSourceEmploymentStatus" DataTextField="NAME"
                                DataValueField="ID" AppendDataBoundItems="true" TabIndex="444">
                                <asp:ListItem Text="" />
                            </asp:DropDownList>
                            <!-- End Form Item #27 -->
                        </td>
                    </tr>
                </asp:Panel>
            </table>
            <!-- TODO: SET TAB INDEX of this panel -->
            <asp:Button ID="btnPTRPSave" runat="server" ValidationGroup="OnSave" Text="  Save  " OnClick="btnPTRPSave_Click" TabIndex="451" />
            &nbsp;&nbsp;
            <asp:Button ID="btnPTRPClose" runat="server" SkinID="CloseButton" UseSubmitBehavior="false" OnClick="btnPTRPClose_Click" TabIndex="452" />
            &nbsp;&nbsp;
            <asp:Button ID="btnPTRPDelete" runat="server" Text="Delete" SkinID="" UseSubmitBehavior="false" OnClick="btnDelete_Click" TabIndex="453"
                    OnClientClick="if(!DeleteConfirmation()) return false;"/>
        </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false" Width="100%">
        You do not have access to the polytrauma id supplied.
        <br />
        <br />
        Please contact the Registry Manager to grant access or verify that your permissions are correct.</asp:Panel>
    <asp:Panel ID="PanelNoInsertAllowed" runat="server" Visible="false" Width="100%">
        You do not have permission to enter new polytrauma entries.
        <br />
        <br />
        Please contact the Registry Manager to grant access or verify that your permissions are correct.</asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false" Width="100%">
        No record found for the polytrauma ID supplied.
        <br />
        <br />
        If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you
        have supplied a correct id.</asp:Panel>
    <asp:HiddenField ID="HiddenFieldEntryID" runat="server" />
    <asp:HiddenField ID="HiddenFieldUserAcceptedSSN" runat="server" />
    <asp:ObjectDataSource ID="ObjectDataSourceGender" runat="server" SelectMethod="GetGenderList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceMaritalStatus" runat="server" SelectMethod="GetMaritalStatusList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceRace" runat="server" SelectMethod="GetRaceList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceEthnicity" runat="server" SelectMethod="GetEthnicityList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourcePolytraumaEntryType" runat="server" SelectMethod="GetPolytraumaEntryType" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceEmergingEtiology" runat="server" SelectMethod="GetEmergingEtiologyList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceVAMC" runat="server" SelectMethod="GetVAMCList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourcePolyTraumaVAMC" runat="server" SelectMethod="GetPolyTraumaVAMCList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceTBIFacilitySource" runat="server" SelectMethod="GetTBIFacilitySourceList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceMilitaryServiceBranch" runat="server" SelectMethod="GetMilitaryServiceBranchList"
        TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceMilitaryServiceStatus" runat="server" SelectMethod="GetMilitartyServiceStatusList"
        TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceDischargeStatus" runat="server" SelectMethod="GetTBIDischargeStatusList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceCombatLocation" runat="server" SelectMethod="GetPolyTraumaCombatLocationList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceRehabDischargeTo" runat="server" SelectMethod="GetRehabDischargeToList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceRehabDischargeTo_InclInactive" runat="server" SelectMethod="GetRehabDischargeToList_InclInactive" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceRehabDischargeToPTRP" runat="server" SelectMethod="GetPTRPRehabDischargeToList"
        TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceFollowUpList" runat="server" SelectMethod="GetPolyTraumaFollowupList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceInjuryDetailList" runat="server" SelectMethod="GetPolyTraumaInjuryDetailList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceSeverityLevelIndexTBI" runat="server" SelectMethod="GetSeverityLevelIndexTBIList"
        TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceFRG" runat="server" SelectMethod="GetTBIFRGList" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourcePTRPPreinjuryPrimaryPersonLivingWith" runat="server" SelectMethod="GetPersonLivingWith"
        TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceEmploymentStatus" runat="server" SelectMethod="GetEmploymentStatus" TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>
</asp:Content>
